using System;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        int[] roomAbove = new int[n + 1];
        int[] hasPlatform = new int[n + 1];
        int[] jumpChanges = new int[n];

        for (int i = 1; i <= n - 1; i++)
        {
            string[] uv = Console.ReadLine().Split();
            int u = int.Parse(uv[0]);
            int v = int.Parse(uv[1]);
            roomAbove[v] = u;
        }

        string[] platforms = Console.ReadLine().Split();
        for (int i = 1; i <= n; i++)
        {
            hasPlatform[i] = int.Parse(platforms[i - 1]);
        }

        string[] changes = Console.ReadLine().Split();
        for (int i = 0; i < n; i++)
        {
            jumpChanges[i] = int.Parse(changes[i]);
        }

        int[] result = MinimumJumps(n, roomAbove, hasPlatform, jumpChanges);

        for (int i = 0; i < n; i++)
        {
            Console.Write(result[i] + " ");
        }
    }

    static int[] MinimumJumps(int n, int[] roomAbove, int[] hasPlatform, int[] jumpChanges)
    {
        int[] result = new int[n];
        result[0] = 1;
        for (int i = 2; i <= n; i++)
        {
            int currentRoom = i;
            int jumps = 0;

            while (currentRoom != 1)
            {
                if (jumpChanges[currentRoom - 2] == 1)
                {
                    hasPlatform[currentRoom] = 1 - hasPlatform[currentRoom];
                }

                if (hasPlatform[roomAbove[currentRoom]] == 1)
                {
                    currentRoom = roomAbove[currentRoom];
                    jumps++;
                }
                else
                {
                    currentRoom = 1; // The rabbit can jump directly out of the cave.
                    jumps++;
                }
            }

            result[i - 1] = jumps;
        }

        return result;
    }
}